import { useState, useEffect } from 'react'
import { ChevronLeft, ChevronRight } from 'lucide-react'
import { motion, AnimatePresence } from 'framer-motion'
import './ImageSlider.css'

const ImageSlider = () => {
  const [currentSlide, setCurrentSlide] = useState(0)
  const images = [
    '/images/ege-1.jpg',
    '/images/ege-2.jpg',
    '/images/ege-3.jpg',
    '/images/ege-4.jpg'
  ]

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentSlide((prev) => (prev + 1) % images.length)
    }, 3000)

    return () => clearInterval(interval)
  }, [images.length])

  const goToPrevious = () => {
    setCurrentSlide((prev) => (prev - 1 + images.length) % images.length)
  }

  const goToNext = () => {
    setCurrentSlide((prev) => (prev + 1) % images.length)
  }

  const goToSlide = (index) => {
    setCurrentSlide(index)
  }

  return (
    <div className="slider-container">
      <div className="slider-wrapper">
        <AnimatePresence mode="wait">
          <motion.div
            key={currentSlide}
            className="slide"
            initial={{ opacity: 0 }}
            animate={{ opacity: 1 }}
            exit={{ opacity: 0 }}
            transition={{ duration: 0.8 }}
            style={{
              backgroundImage: `url(${images[currentSlide]})`
            }}
          >
            <div className="slide-overlay"></div>
          </motion.div>
        </AnimatePresence>
        <button className="slider-btn slider-btn-prev" onClick={goToPrevious}>
          <ChevronLeft size={20} strokeWidth={1.5} />
        </button>
        <button className="slider-btn slider-btn-next" onClick={goToNext}>
          <ChevronRight size={20} strokeWidth={1.5} />
        </button>
        <div className="slider-dots">
          {images.map((_, index) => (
            <button
              key={index}
              className={`dot ${index === currentSlide ? 'active' : ''}`}
              onClick={() => goToSlide(index)}
              aria-label={`Go to slide ${index + 1}`}
            />
          ))}
        </div>
      </div>
    </div>
  )
}

export default ImageSlider

